<?php
$hudson_edge_icon_collections = hudson_edge_return_icon_collections();

$generalPage = new HudsonEdgeAdminPage(
	"",
	esc_html__( "General", 'hudson' ),
	"fa fa-institution"
);
$hudson_edge_framework->edgtOptions->addAdminPage(
	"general",
	$generalPage
);

// Design Style

$panel1 = new HudsonEdgePanel(
	esc_html__( "Design Style", 'hudson' ),
	"design_style"
);
$generalPage->addChild(
	"panel1",
	$panel1
);

$google_fonts = new HudsonEdgeField(
	"font",
	"google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "Choose a default Google font for your site", 'hudson' )
);
$panel1->addChild(
	"google_fonts",
	$google_fonts
);

$additional_google_fonts = new HudsonEdgeField(
	"yesno",
	"additional_google_fonts",
	"no",
	esc_html__( "Additional Google Fonts", 'hudson' ),
	"",
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_additional_google_font_container"
	)
);
$panel1->addChild(
	"additional_google_fonts",
	$additional_google_fonts
);

$additional_google_font_container = new HudsonEdgeContainer(
	"additional_google_font_container",
	"additional_google_fonts",
	"no"
);
$panel1->addChild(
	"additional_google_font_container",
	$additional_google_font_container
);

$additional_google_font1 = new HudsonEdgeField(
	"font",
	"additional_google_font1",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "Choose additional Google font for your site", 'hudson' )
);
$additional_google_font_container->addChild(
	"additional_google_font1",
	$additional_google_font1
);

$additional_google_font2 = new HudsonEdgeField(
	"font",
	"additional_google_font2",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "Choose additional Google font for your site", 'hudson' )
);
$additional_google_font_container->addChild(
	"additional_google_font2",
	$additional_google_font2
);

$additional_google_font3 = new HudsonEdgeField(
	"font",
	"additional_google_font3",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "Choose additional Google font for your site", 'hudson' )
);
$additional_google_font_container->addChild(
	"additional_google_font3",
	$additional_google_font3
);

$additional_google_font4 = new HudsonEdgeField(
	"font",
	"additional_google_font4",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "Choose additional Google font for your site", 'hudson' )
);
$additional_google_font_container->addChild(
	"additional_google_font4",
	$additional_google_font4
);

$additional_google_font5 = new HudsonEdgeField(
	"font",
	"additional_google_font5",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "Choose additional Google font for your site", 'hudson' )
);
$additional_google_font_container->addChild(
	"additional_google_font5",
	$additional_google_font5
);

$first_color = new HudsonEdgeField(
	"color",
	"first_color",
	"",
	esc_html__( "First Main Color", 'hudson' ),
	esc_html__( "Choose the most dominant theme color. Default color is #e6ae48.", 'hudson' )
);
$panel1->addChild(
	"first_color",
	$first_color
);

$selection_color = new HudsonEdgeField(
	"color",
	"selection_color",
	"",
	esc_html__( "Text Selection Color", 'hudson' ),
	esc_html__( "Choose the color users see when selecting text", 'hudson' )
);
$panel1->addChild(
	"selection_color",
	$selection_color
);

$transparent_content = new HudsonEdgeField(
	"yesno",
	"transparent_content",
	"no",
	esc_html__( "Enable Uniform Site Background", 'hudson' ),
	esc_html__( "If enabled, content background on pages will be transparent (unless set otherwise) and the background you set here will show", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_transparent_content_container"
	)
);
$panel1->addChild(
	"transparent_content",
	$transparent_content
);

$transparent_content_container = new HudsonEdgeContainer(
	"transparent_content_container",
	"transparent_content",
	"no"
);
$panel1->addChild(
	"transparent_content_container",
	$transparent_content_container
);

$transparent_content_background_color = new HudsonEdgeField(
	"color",
	"transparent_content_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose body background color. Default color is #ffffff.", 'hudson' )
);
$transparent_content_container->addChild(
	"transparent_content_background_color",
	$transparent_content_background_color
);

$transparent_content_background_image = new HudsonEdgeField(
	"image",
	"transparent_content_background_image",
	"",
	esc_html__( "Background Image", 'hudson' ),
	esc_html__( "Choose an image to be displayed in background", 'hudson' )
);
$transparent_content_container->addChild(
	"transparent_content_background_image",
	$transparent_content_background_image
);

$transparent_content_pattern_background_image = new HudsonEdgeField(
	"image",
	"transparent_content_pattern_background_image",
	"",
	esc_html__( "Background Pattern", 'hudson' ),
	esc_html__( "Choose an image to be used as background pattern", 'hudson' )
);
$transparent_content_container->addChild(
	"transparent_content_pattern_background_image",
	$transparent_content_pattern_background_image
);

$boxed = new HudsonEdgeField(
	"yesno",
	"boxed",
	"no",
	esc_html__( "Boxed layout", 'hudson' ),
	esc_html__( "Enabling this option will display site content in grid", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_boxed_container"
	)
);
$panel1->addChild(
	"boxed",
	$boxed
);

$boxed_container = new HudsonEdgeContainer(
	"boxed_container",
	"boxed",
	"no"
);
$panel1->addChild(
	"boxed_container",
	$boxed_container
);

$spacing_arround_content = new HudsonEdgeField(
	"yesno",
	"spacing_arround_content",
	"no",
	esc_html__( "Spacing around content", 'hudson' ),
	esc_html__( "Enabling this option will set a spacing around the boxed content", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_spacing_arround_content_container"
	)
);
$boxed_container->addChild(
	"spacing_arround_content",
	$spacing_arround_content
);

$spacing_arround_content_container = new HudsonEdgeContainer(
	"spacing_arround_content_container",
	"spacing_arround_content",
	"no"
);
$boxed_container->addChild(
	"spacing_arround_content_container",
	$spacing_arround_content_container
);

$spacing_amount = new HudsonEdgeField(
	"text",
	"spacing_amount",
	"",
	esc_html__( "Spacing amount (px)", 'hudson' ),
	esc_html__( "Enter the amount for the spacing around boxed content (default is 25)", 'hudson' ),
	array(),
	array( "col_width" => 1 )
);
$spacing_arround_content_container->addChild(
	"spacing_amount",
	$spacing_amount
);

$footer_in_content = new HudsonEdgeField(
	"yesno",
	"footer_in_content",
	"no",
	esc_html__( "Include footer in content area", 'hudson' ),
	esc_html__( "Enabling this option will include the footer in the content area, so the set spacing will wrap around the footer area as well. Otherwise the spacing will separate the footer and content.", 'hudson' )
);
$spacing_arround_content_container->addChild(
	"footer_in_content",
	$footer_in_content
);

$frame_around_content = new HudsonEdgeField(
	"yesno",
	"frame_around_content",
	"no",
	esc_html__( "Frame around content", 'hudson' ),
	esc_html__( "Enabling this option will set a frame around the content", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_frame_around_content_container"
	)
);
$spacing_arround_content_container->addChild(
	"frame_around_content",
	$frame_around_content
);

$frame_around_content_container = new HudsonEdgeContainer(
	"frame_around_content_container",
	"frame_around_content",
	"no"
);
$spacing_arround_content_container->addChild(
	"frame_around_content_container",
	$frame_around_content_container
);

$frame_around_content_width = new HudsonEdgeField(
	"text",
	"frame_around_content_width",
	"",
	esc_html__( "Frame width (px)", 'hudson' ),
	esc_html__( "Enter the width of the frame (default is 15)", 'hudson' ),
	array(),
	array( "col_width" => 1 )
);
$frame_around_content_container->addChild(
	"frame_around_content_width",
	$frame_around_content_width
);

$frame_around_content_color = new HudsonEdgeField(
	"color",
	"frame_around_content_color",
	"",
	esc_html__( "Frame Color", 'hudson' ),
	esc_html__( "Choose a color for frame", 'hudson' )
);
$frame_around_content_container->addChild(
	"frame_around_content_color",
	$frame_around_content_color
);

$frame_around_content_pattern = new HudsonEdgeField(
	"image",
	"frame_around_content_pattern",
	"",
	esc_html__( "Pattern Image", 'hudson' ),
	esc_html__( "Choose an image to be used as a pattern in the frame around the content", 'hudson' )
);
$frame_around_content_container->addChild(
	"frame_around_content_pattern",
	$frame_around_content_pattern
);

$background_color_box = new HudsonEdgeField(
	"color",
	"background_color_box",
	"",
	esc_html__( "Page Background Color", 'hudson' ),
	esc_html__( "Choose the page background (body) color. Default color is #f5f5f5.", 'hudson' )
);
$boxed_container->addChild(
	"background_color_box",
	$background_color_box
);

$background_image = new HudsonEdgeField(
	"image",
	"background_image",
	"",
	esc_html__( "Background Image", 'hudson' ),
	esc_html__( "Choose an image to be displayed in background", 'hudson' )
);
$boxed_container->addChild(
	"background_image",
	$background_image
);

$pattern_background_image = new HudsonEdgeField(
	"image",
	"pattern_background_image",
	"",
	esc_html__( "Background Pattern", 'hudson' ),
	esc_html__( "Choose an image to be used as background pattern", 'hudson' )
);
$boxed_container->addChild(
	"pattern_background_image",
	$pattern_background_image
);

$background_image_attachment = new HudsonEdgeField(
	"select",
	"background_image_attachment",
	"fixed",
	esc_html__( "Background Attachment", 'hudson' ),
	esc_html__( "Choose background attachment behavior", 'hudson' ),
	array(
		"fixed" => esc_html__( "Fixed", 'hudson' ),
		"scroll" => esc_html__( "Scroll", 'hudson' )
	)
);
$boxed_container->addChild(
	"background_image_attachment",
	$background_image_attachment
);

$boxed_padding_general = new HudsonEdgeField(
	"text",
	"boxed_padding_general",
	"",
	esc_html__( "Left/Right Padding on Content (%)", 'hudson' ),
	esc_html__( "Insert left(right) padding that will apply generaly", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$boxed_container->addChild(
	"boxed_padding_general",
	$boxed_padding_general
);

$boxed_padding_on_header = new HudsonEdgeField(
	"yesno",
	"boxed_padding_on_header",
	"no",
	esc_html__( "Left/Right Padding Affects Header", 'hudson' ),
	esc_html__( "By enabling this option the left/right padding will affect header", 'hudson' )
);
$boxed_container->addChild(
	"boxed_padding_on_header",
	$boxed_padding_on_header
);

$boxed_padding_on_header_footer = new HudsonEdgeField(
	"yesno",
	"boxed_padding_on_header_footer",
	"no",
	esc_html__( "Left/Right Padding Affects Header and Footer", 'hudson' ),
	esc_html__( "By enabling this option the left/right padding will affect header and footer also", 'hudson' )
);
$boxed_container->addChild(
	"boxed_padding_on_header_footer",
	$boxed_padding_on_header_footer
);

$boxed_padding_on_title_content = new HudsonEdgeField(
	"yesno",
	"boxed_padding_on_title_content",
	"no",
	esc_html__( "Left/Right Padding Affects Title Content", 'hudson' ),
	esc_html__( "By enabling this option the left/right padding will affect title content", 'hudson' )
);
$boxed_container->addChild(
	"boxed_padding_on_title_content",
	$boxed_padding_on_title_content
);

$boxed_padding_on_title_container = new HudsonEdgeField(
	"yesno",
	"boxed_padding_on_title_container",
	"no",
	esc_html__( "Left/Right Padding Affects Title Container", 'hudson' ),
	esc_html__( "By enabling this option the left/right padding will affect title container (including title image)", 'hudson' )
);
$boxed_container->addChild(
	"boxed_padding_on_title_container",
	$boxed_padding_on_title_container
);

$paspartu = new HudsonEdgeField(
	"yesno",
	"paspartu",
	"no",
	esc_html__( "Passepartout", 'hudson' ),
	esc_html__( "Enabling this option will display passepartout around site content", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_paspartu_container"
	)
);
$panel1->addChild(
	"paspartu",
	$paspartu
);

$paspartu_container = new HudsonEdgeContainer(
	"paspartu_container",
	"paspartu",
	"no"
);
$panel1->addChild(
	"paspartu_container",
	$paspartu_container
);

$paspartu_color = new HudsonEdgeField(
	"color",
	"paspartu_color",
	"",
	esc_html__( "Passepartout Color", 'hudson' ),
	esc_html__( "Choose passepartout color, default value is #ffffff", 'hudson' )
);
$paspartu_container->addChild(
	"paspartu_color",
	$paspartu_color
);

$paspartu_width = new HudsonEdgeField(
	"text",
	"paspartu_width",
	"",
	esc_html__( "Passepartout Size (%)", 'hudson' ),
	esc_html__( "Enter size amount for passepartout, default value is 2% (the percent is in relation to site width)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$paspartu_container->addChild(
	"paspartu_width",
	$paspartu_width
);

$paspartu_border_on_edges = new HudsonEdgeField(
	"yesno",
	"paspartu_border_on_edges",
	"no",
	esc_html__( "Border on passepartout edges", 'hudson' ),
	esc_html__( "Enabling this option will display 1px border on passepartout, only if top and bottom passepartouts are fixed", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_paspartu_border_on_edges_container"
	)
);
$paspartu_container->addChild(
	"paspartu_border_on_edges",
	$paspartu_border_on_edges
);

$paspartu_border_on_edges_container = new HudsonEdgeContainer(
	"paspartu_border_on_edges_container",
	"paspartu_border_on_edges",
	"no"
);
$paspartu_container->addChild(
	"paspartu_border_on_edges_container",
	$paspartu_border_on_edges_container
);

$paspartu_border_on_edges_color = new HudsonEdgeField(
	"color",
	"paspartu_border_on_edges_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose border color, default value is #e6e6e6", 'hudson' )
);
$paspartu_border_on_edges_container->addChild(
	"paspartu_border_on_edges_color",
	$paspartu_border_on_edges_color
);

$paspartu_header_alignment = new HudsonEdgeField(
	"yesno",
	"paspartu_header_alignment",
	"no",
	esc_html__( "Align Header With Passepartout", 'hudson' ),
	esc_html__( "Enabling this option will align header content with passepartout borders", 'hudson' )
);
$paspartu_container->addChild(
	"paspartu_header_alignment",
	$paspartu_header_alignment
);

$paspartu_below_tittle = new HudsonEdgeField(
	"yesno",
	"paspartu_below_tittle",
	"no",
	esc_html__( "Passepartout Below Title", 'hudson' ),
	esc_html__( "Enabling this option will place passepartout below title", 'hudson' )
);
$paspartu_container->addChild(
	"paspartu_below_tittle",
	$paspartu_below_tittle
);

$paspartu_header_inside = new HudsonEdgeField(
	"yesno",
	"paspartu_header_inside",
	"no",
	esc_html__( "Set Header Inside Passepartout", 'hudson' ),
	esc_html__( "Enabling this option will set the whole header between the left and right border of passepartout", 'hudson' )
);
$paspartu_container->addChild(
	"paspartu_header_inside",
	$paspartu_header_inside
);

$vertical_menu_inside_paspartu = new HudsonEdgeField(
	"yesno",
	"vertical_menu_inside_paspartu",
	"yes",
	esc_html__( "Vertical Menu Inside Passepartout", 'hudson' ),
	""
);
$paspartu_container->addChild(
	"vertical_menu_inside_paspartu",
	$vertical_menu_inside_paspartu
);

$paspartu_footer_alignment = new HudsonEdgeField(
	"yesno",
	"paspartu_footer_alignment",
	"no",
	esc_html__( "Align Footer With Passepartout", 'hudson' ),
	esc_html__( "Enabling this option will align footer content with passepartout borders", 'hudson' )
);
$paspartu_container->addChild(
	"paspartu_footer_alignment",
	$paspartu_footer_alignment
);

$paspartu_on_top = new HudsonEdgeField(
	"yesno",
	"paspartu_on_top",
	"yes",
	esc_html__( "Top Passepartout", 'hudson' ),
	esc_html__( "Disabling this option will disable top part of passepartout", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_paspartu_on_top_fixed_container"
	)
);
$paspartu_container->addChild(
	"paspartu_on_top",
	$paspartu_on_top
);

$paspartu_on_top_fixed_container = new HudsonEdgeContainer(
	"paspartu_on_top_fixed_container",
	"paspartu_on_top",
	"no"
);
$paspartu_container->addChild(
	"paspartu_on_top_fixed_container",
	$paspartu_on_top_fixed_container
);

$paspartu_on_top_fixed = new HudsonEdgeField(
	"yesno",
	"paspartu_on_top_fixed",
	"no",
	esc_html__( "Fix Top Passepartout", 'hudson' ),
	esc_html__( "Enabling this option will fix top part of passepartout to the top of the screen", 'hudson' )
);
$paspartu_on_top_fixed_container->addChild(
	"paspartu_on_top_fixed",
	$paspartu_on_top_fixed
);

$paspartu_on_bottom_slider_container = new HudsonEdgeContainer(
	"paspartu_on_bottom_slider_container",
	"",
	""
);
$paspartu_container->addChild(
	"paspartu_on_bottom_slider_container",
	$paspartu_on_bottom_slider_container
);

$paspartu_on_bottom_slider = new HudsonEdgeField(
	"yesno",
	"paspartu_on_bottom_slider",
	"no",
	esc_html__( "Show Bottom Passepartout on Edge Slider", 'hudson' ),
	esc_html__( "Enabling this option will show bottom passepartout on Edge Slider", 'hudson' )
);
$paspartu_on_bottom_slider_container->addChild(
	"paspartu_on_bottom_slider",
	$paspartu_on_bottom_slider
);

$paspartu_on_bottom = new HudsonEdgeField(
	"yesno",
	"paspartu_on_bottom",
	"yes",
	esc_html__( "Bottom Passepartout", 'hudson' ),
	esc_html__( "Disabling this option will disable bottom part of passepartout", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_paspartu_on_bottom_fixed_container"
	)
);
$paspartu_container->addChild(
	"paspartu_on_bottom",
	$paspartu_on_bottom
);

$paspartu_on_bottom_fixed_container = new HudsonEdgeContainer(
	"paspartu_on_bottom_fixed_container",
	"paspartu_on_bottom",
	"no"
);
$paspartu_container->addChild(
	"paspartu_on_bottom_fixed_container",
	$paspartu_on_bottom_fixed_container
);

$paspartu_on_bottom_fixed = new HudsonEdgeField(
	"yesno",
	"paspartu_on_bottom_fixed",
	"no",
	esc_html__( "Fix Bottom Passepartout", 'hudson' ),
	esc_html__( "Enabling this option will fix bottom part of passepartout to the bottom of the screen", 'hudson' )
);
$paspartu_on_bottom_fixed_container->addChild(
	"paspartu_on_bottom_fixed",
	$paspartu_on_bottom_fixed
);

$paspartu_portfolio_full_width = new HudsonEdgeField(
	"yesno",
	"paspartu_portfolio_full_width",
	"no",
	esc_html__( "Full Width Portfolio List in Passepartout", 'hudson' ),
	esc_html__( "Enabling this option will set portfolio lists within the passepartout to full width of content; otherwise there is a small padding between portfolio and passepartout", 'hudson' )
);
$paspartu_container->addChild(
	"paspartu_portfolio_full_width",
	$paspartu_portfolio_full_width
);

$preload_pattern_image = new HudsonEdgeField(
	"image",
	"preload_pattern_image",
	HUDSON_EDGE_ROOT . "/img/preload_pattern.png",
	esc_html__( "Preload Pattern Image", 'hudson' ),
	esc_html__( "Choose preload pattern image to be displayed until images are loaded ", 'hudson' )
);
$panel1->addChild(
	"preload_pattern_image",
	$preload_pattern_image
);

$element_appear_amount = new HudsonEdgeField(
	"text",
	"element_appear_amount",
	"",
	esc_html__( "Element Appearance (px)", 'hudson' ),
	esc_html__( "For animated elements, set distance (related to browser bottom) to start the animation", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel1->addChild(
	"element_appear_amount",
	$element_appear_amount
);

// Settings

$panel4 = new HudsonEdgePanel(
	esc_html__( "Settings", 'hudson' ),
	"settings"
);
$generalPage->addChild(
	"panel4",
	$panel4
);

$page_transitions = new HudsonEdgeField(
	"select",
	"page_transitions",
	"0",
	esc_html__( "Page Transition", 'hudson' ),
	esc_html__( 'Choose a a type of transition between loading pages. In order for animation to work properly, you must choose "Post name" in permalinks settings', 'hudson' ),
	array(
		0 => "No animation",
		1 => "Up/Down",
		2 => "Fade",
		3 => "Up/Down (In) / Fade (Out)",
		4 => "Left/Right"
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"0" => "#edgtf_ajax_animate_header_container",
			"1" => "",
			"2" => "",
			"3" => "",
			"4" => ""
		),
		"show"       => array(
			"0" => "",
			"1" => "#edgtf_ajax_animate_header_container",
			"2" => "#edgtf_ajax_animate_header_container",
			"3" => "#edgtf_ajax_animate_header_container",
			"4" => "#edgtf_ajax_animate_header_container"
		)
	),
	"enable_grid_elements",
	array( "yes" )
);
$panel4->addChild(
	"page_transitions",
	$page_transitions
);

$page_transitions_notice = new HudsonEdgeNotice(
	esc_html__( "Page Transition", 'hudson' ),
	esc_html__( 'Choose a a type of transition between loading pages. In order for animation to work properly, you must choose "Post name" in permalinks settings', 'hudson' ),
	esc_html__( "Page transition is disabled because VC Grid is Enabled", 'hudson' ),
	"enable_grid_elements",
	"no"
);
$panel4->addChild(
	"page_transitions_notice",
	$page_transitions_notice
);

$ajax_animate_header_container = new HudsonEdgeContainer(
	"ajax_animate_header_container",
	"page_transitions",
	"0"
);
$panel4->addChild(
	"ajax_animate_header_container",
	$ajax_animate_header_container
);

$ajax_animate_header = new HudsonEdgeField(
	"yesno",
	"ajax_animate_header",
	"no",
	esc_html__( "Animate Header", 'hudson' ),
	esc_html__( "Enabling this option will include the header area in the Ajax Page Transition Animations", 'hudson' )
);
$ajax_animate_header_container->addChild(
	"ajax_animate_header",
	$ajax_animate_header
);

$loading_animation = new HudsonEdgeField(
	"onoff",
	"loading_animation",
	"off",
	esc_html__( "Loading Animation", 'hudson' ),
	esc_html__( "Enabling this option will display animation while page loads", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_loading_animation_container"
	)
);
$panel4->addChild(
	"loading_animation",
	$loading_animation
);

$loading_animation_container = new HudsonEdgeContainer(
	"loading_animation_container",
	"loading_animation",
	"off"
);
$panel4->addChild(
	"loading_animation_container",
	$loading_animation_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Loading Animation Graphic", 'hudson' ),
	esc_html__( "Choose type and color of preload graphic animation", 'hudson' )
);
$loading_animation_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$loading_animation_spinner = new HudsonEdgeField(
	"selectsimple",
	"loading_animation_spinner",
	"pulse",
	esc_html__( "Spinner", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"pulse" => esc_html__( "Pulse", 'hudson' ),
		"double_pulse" => esc_html__( "Double Pulse", 'hudson' ),
		"cube" => esc_html__( "Cube", 'hudson' ),
		"rotating_cubes" => esc_html__( "Rotating Cubes", 'hudson' ),
		"stripes" => esc_html__( "Stripes", 'hudson' ),
		"wave" => esc_html__( "Wave", 'hudson' ),
		"two_rotating_circles" => esc_html__( "2 Rotating Circles", 'hudson' ),
		"five_rotating_circles" => esc_html__( "5 Rotating Circles", 'hudson' ),
		"atom" => esc_html__( "Atom", 'hudson' ),
		"clock" => esc_html__( "Clock", 'hudson' ),
		"mitosis" => esc_html__( "Mitosis", 'hudson' ),
		"lines" => esc_html__( "Lines", 'hudson' ),
		"fussion" => esc_html__( "Fussion", 'hudson' ),
		"wave_circles" => esc_html__( "Wave Circles", 'hudson' ),
		"pulse_circles" => esc_html__( "Pulse Circles", 'hudson' ),
		"line" => esc_html__( "Line", 'hudson' ),
		"wide_line" => esc_html__( "Wide Line", 'hudson' )
	)
);
$row1->addChild(
	"loading_animation_spinner",
	$loading_animation_spinner
);

$spinner_color = new HudsonEdgeField(
	"colorsimple",
	"spinner_color",
	"",
	esc_html__( "Spinner Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"spinner_color",
	$spinner_color
);

$loading_image = new HudsonEdgeField(
	"image",
	"loading_image",
	"",
	esc_html__( "Loading Image", 'hudson' ),
	esc_html__( 'Upload custom image to be displayed while page loads (Note: Page Transition must not be set to "No Animation")', 'hudson' )
);
$loading_animation_container->addChild(
	"loading_image",
	$loading_image
);

$smooth_scroll = new HudsonEdgeField(
	"yesno",
	"smooth_scroll",
	"yes",
	esc_html__( "Smooth Scroll", 'hudson' ),
	esc_html__( "Enabling this option will perform a smooth scrolling effect on every page (except on Mac and touch devices)", 'hudson' )
);
$panel4->addChild(
	"smooth_scroll",
	$smooth_scroll
);

$elements_animation_on_touch = new HudsonEdgeField(
	"yesno",
	"elements_animation_on_touch",
	"no",
	esc_html__( "Elements Animation on Mobile/Touch Devices", 'hudson' ),
	esc_html__( "Enabling this option will allow elements (shortcodes) to animate on mobile / touch devices", 'hudson' )
);
$panel4->addChild(
	"elements_animation_on_touch",
	$elements_animation_on_touch
);

$show_back_button = new HudsonEdgeField(
	"yesno",
	"show_back_button",
	"yes",
	esc_html__( "Show 'Back To Top Button'", 'hudson' ),
	esc_html__( "Enabling this option will display a Back to Top button on every page", 'hudson' )
);
$panel4->addChild(
	"show_back_button",
	$show_back_button
);

$responsiveness = new HudsonEdgeField(
	"yesno",
	"responsiveness",
	"yes",
	esc_html__( "Responsiveness", 'hudson' ),
	esc_html__( "Enabling this option will make all pages responsive", 'hudson' )
);
$panel4->addChild(
	"responsiveness",
	$responsiveness
);

$favicon_image = new HudsonEdgeField(
	"image",
	"favicon_image",
	HUDSON_EDGE_ROOT . "/img/favicon.ico",
	esc_html__( "Favicon Image", 'hudson' ),
	esc_html__( "Choose a favicon image to be displayed", 'hudson' )
);
$panel4->addChild(
	"favicon_image",
	$favicon_image
);

$internal_no_ajax_links = new HudsonEdgeField(
	"textarea",
	"internal_no_ajax_links",
	"",
	esc_html__( "List of Internal URLs Loaded Without AJAX (Separated With Comma)", 'hudson' ),
	esc_html__( "To disable AJAX transitions on certain pages, enter their full URLs here (for example: http://www.mydomain.com/forum/)", 'hudson' )
);
$panel4->addChild(
	"internal_no_ajax_links",
	$internal_no_ajax_links
);

// Custom Code

$panel3 = new HudsonEdgePanel(
	esc_html__( "Custom Code", 'hudson' ),
	"custom_code"
);
$generalPage->addChild(
	"panel3",
	$panel3
);

$custom_css = new HudsonEdgeField(
	"textarea",
	"custom_css",
	"",
	esc_html__( "Custom CSS", 'hudson' ),
	esc_html__( "Enter your custom CSS here", 'hudson' )
);
$panel3->addChild(
	"custom_css",
	$custom_css
);

$custom_js = new HudsonEdgeField(
	"textarea",
	"custom_js",
	"",
	esc_html__( "Custom JS", 'hudson' ),
	esc_html__( 'Enter your custom Javascript here (jQuery selector is "$j" because of the conflict mode)', 'hudson' )
);
$panel3->addChild(
	"custom_js",
	$custom_js
);

// Google Maps API key

$panel5 = new HudsonEdgePanel(
	esc_html__( "Google Maps API key", 'hudson' ),
	"google_maps_api_key"
);
$generalPage->addChild(
	"panel5",
	$panel5
);

$google_maps_api_key = new HudsonEdgeField(
	"text",
	"google_maps_api_key",
	"",
	esc_html__( "Google Maps API key", 'hudson' ),
	esc_html__( "Enter your Google Maps API key here", 'hudson' )
);
$panel5->addChild(
	"google_maps_api_key",
	$google_maps_api_key
);

// SEO

$panel2 = new HudsonEdgePanel(
	esc_html__( "SEO", 'hudson' ),
	"seo"
);
$generalPage->addChild(
	"panel2",
	$panel2
);

$disable_edgt_seo = new HudsonEdgeField(
	"yesno",
	"disable_edgt_seo",
	"no",
	esc_html__( "Disable SEO", 'hudson' ),
	esc_html__( "Enabling this option will turn off SEO", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_disable_edgt_seo_container",
		"dependence_show_on_yes" => ""
	)
);
$panel2->addChild(
	"disable_edgt_seo",
	$disable_edgt_seo
);

$disable_edgt_seo_container = new HudsonEdgeContainer(
	"disable_edgt_seo_container",
	"disable_edgt_seo",
	"yes"
);
$panel2->addChild(
	"disable_edgt_seo_container",
	$disable_edgt_seo_container
);

$meta_keywords = new HudsonEdgeField(
	"textarea",
	"meta_keywords",
	"",
	esc_html__( "Meta Keywords", 'hudson' ),
	esc_html__( "Add relevant keywords separated with commas to improve SEO", 'hudson' )
);
$disable_edgt_seo_container->addChild(
	"meta_keywords",
	$meta_keywords
);

$meta_description = new HudsonEdgeField(
	"textarea",
	"meta_description",
	"",
	esc_html__( "Meta Description", 'hudson' ),
	esc_html__( "Enter a short description of the website for SEO", 'hudson' )
);
$disable_edgt_seo_container->addChild(
	"meta_description",
	$meta_description
);

//Maintenance mode
$edgt_pages = array();
$pages      = get_posts(
	array(
		'post_type' => esc_html__( 'page', 'hudson' ),
		'meta_key' => esc_html__( '_wp_page_template', 'hudson' ),
		'meta_value' => esc_html__( 'landing_page.php', 'hudson' )
	)
);
foreach ( $pages as $page ) {
	$edgt_pages[ $page->ID ] = $page->post_title;
}

$panel_maintenance = new HudsonEdgePanel(
	esc_html__( "Maintenance Mode", 'hudson' ),
	"maintenance_panel"
);
$generalPage->addChild(
	"panel_maintenance",
	$panel_maintenance
);

$maintenance_mode = new HudsonEdgeField(
	"yesno",
	"edgt_maintenance_mode",
	"no",
	esc_html__( "Maintenance Mode", 'hudson' ),
	esc_html__( "Turn on this option if you want to enable maintenance mode on your site", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_maintenance_container"
	)
);
$panel_maintenance->addChild(
	"edgt_maintenance_mode",
	$maintenance_mode
);

$maintenance_container = new HudsonEdgeContainer(
	"maintenance_container",
	"edgt_maintenance_mode",
	"no"
);
$panel_maintenance->addChild(
	"maintenance_container",
	$maintenance_container
);

$generalPage = new HudsonEdgeField(
	"selectblank",
	"edgt_maintenance_page",
	"",
	esc_html__( 'Maintenance Page', 'hudson' ),
	esc_html__( 'Choose maintenance page to display when user visits your site', 'hudson' ),
	$edgt_pages
);
$maintenance_container->addChild(
	"edgt_maintenance_page",
	$generalPage
);